(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     16138,        448]*)
(*NotebookOutlinePosition[     16982,        475]*)
(*  CellTagsIndexPosition[     16938,        471]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(\( (*\ Example\ 8.4  .8\ *) \)\(\[IndentingNewLine]\)\( (*\ 
      Integrate\ s^3\ Log | x - s | \ ds\ from\ 0\ to\ 1, \ 
      with\ stepsize\ 0.1\ *) \)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ Exact\ solution\ *) \[IndentingNewLine]\(integrand[x_, s_] := \ 
        s^3*Log[Abs[x - s]];\)\), "\[IndentingNewLine]", 
    \(NIntegrate[integrand[0, s], {s, 0, 1}]\)}], "Input"],

Cell[BoxData[
    \(\(-0.06249999999639723`\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[integrand[0.1, s], {s, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(NIntegrate::"ncvb" \(\(:\)\(\ \)\) 
      "NIntegrate failed to converge to prescribed accuracy after \!\(7\) \
recursive bisections in \!\(s\) near \!\(s\) = \!\(0.09765625`\)."\)], \
"Message"],

Cell[BoxData[
    \(\(-0.09872807458121124`\)\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(NIntegrate[integrand[0.2, s], {s, 0, 1}]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[integrand[0.1, s], {s, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(NIntegrate::"ncvb" \(\(:\)\(\ \)\) 
      "NIntegrate failed to converge to prescribed accuracy after \!\(7\) \
recursive bisections in \!\(s\) near \!\(s\) = \!\(0.19921875`\)."\)], \
"Message"],

Cell[BoxData[
    \(\(-0.14250307367745427`\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[integrand[0.3, s], {s, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(NIntegrate::"slwcon" \(\(:\)\(\ \)\) 
      "Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration being 0, oscillatory \
integrand, or insufficient WorkingPrecision. If your integrand is oscillatory \
try using the option Method->Oscillatory in NIntegrate."\)], "Message"],

Cell[BoxData[
    \(NIntegrate::"ncvb" \(\(:\)\(\ \)\) 
      "NIntegrate failed to converge to prescribed accuracy after \!\(7\) \
recursive bisections in \!\(s\) near \!\(s\) = \!\(0.30078125`\)."\)], \
"Message"],

Cell[BoxData[
    \(\(-0.1963709156660298`\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[integrand[0.4, s], {s, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(NIntegrate::"slwcon" \(\(:\)\(\ \)\) 
      "Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration being 0, oscillatory \
integrand, or insufficient WorkingPrecision. If your integrand is oscillatory \
try using the option Method->Oscillatory in NIntegrate."\)], "Message"],

Cell[BoxData[
    \(NIntegrate::"ncvb" \(\(:\)\(\ \)\) 
      "NIntegrate failed to converge to prescribed accuracy after \!\(7\) \
recursive bisections in \!\(s\) near \!\(s\) = \!\(0.40234375`\)."\)], \
"Message"],

Cell[BoxData[
    \(\(-0.2621146252874615`\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[integrand[0.5, s], {s, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(NIntegrate::"inum" \(\(:\)\(\ \)\) 
      "Integrand \!\(Indeterminate\) is not numerical at \!\({s}\) = \
\!\({1\/2}\)."\)], "Message"],

Cell[BoxData[
    \(NIntegrate[integrand[0.5`, s], {s, 0, 1}]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[integrand[0.6, s], {s, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(NIntegrate::"slwcon" \(\(:\)\(\ \)\) 
      "Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration being 0, oscillatory \
integrand, or insufficient WorkingPrecision. If your integrand is oscillatory \
try using the option Method->Oscillatory in NIntegrate."\)], "Message"],

Cell[BoxData[
    \(NIntegrate::"ncvb" \(\(:\)\(\ \)\) 
      "NIntegrate failed to converge to prescribed accuracy after \!\(7\) \
recursive bisections in \!\(s\) near \!\(s\) = \!\(0.59765625`\)."\)], \
"Message"],

Cell[BoxData[
    \(\(-0.4273674933025092`\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[integrand[0.7, s], {s, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(NIntegrate::"slwcon" \(\(:\)\(\ \)\) 
      "Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration being 0, oscillatory \
integrand, or insufficient WorkingPrecision. If your integrand is oscillatory \
try using the option Method->Oscillatory in NIntegrate."\)], "Message"],

Cell[BoxData[
    \(NIntegrate::"ncvb" \(\(:\)\(\ \)\) 
      "NIntegrate failed to converge to prescribed accuracy after \!\(7\) \
recursive bisections in \!\(s\) near \!\(s\) = \!\(0.69921875`\)."\)], \
"Message"],

Cell[BoxData[
    \(\(-0.5177954789422546`\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[integrand[0.8, s], {s, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(NIntegrate::"slwcon" \(\(:\)\(\ \)\) 
      "Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration being 0, oscillatory \
integrand, or insufficient WorkingPrecision. If your integrand is oscillatory \
try using the option Method->Oscillatory in NIntegrate."\)], "Message"],

Cell[BoxData[
    \(NIntegrate::"ncvb" \(\(:\)\(\ \)\) 
      "NIntegrate failed to converge to prescribed accuracy after \!\(7\) \
recursive bisections in \!\(s\) near \!\(s\) = \!\(0.80078125`\)."\)], \
"Message"],

Cell[BoxData[
    \(\(-0.5973122240219991`\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[integrand[0.9, s], {s, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(NIntegrate::"ncvb" \(\(:\)\(\ \)\) 
      "NIntegrate failed to converge to prescribed accuracy after \!\(7\) \
recursive bisections in \!\(s\) near \!\(s\) = \!\(0.90234375`\)."\)], \
"Message"],

Cell[BoxData[
    \(\(-0.6360173126544113`\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[integrand[1, s], {s, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(\(-0.5208333333333244`\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\( (*\ 
      Now\ compute\ the\ integral\ by\ Simpson' 
        s\ rule\ *) \)\(\[IndentingNewLine]\)\( (*\(\(n = \(2\  : \ 
                result = \((\([f[s1] + 4\ f[s2] + f[s3]\)\)\)\)\()\)\)/
        6, \ \[IndentingNewLine]where\ s1 = 0, \ s2 = 0.5, \ s3 = 1, \ 
      and\ f = integrand; \[IndentingNewLine]compute\ for\ x =  .1\ to\  .4, \
\ and\  .6\ to\  .9\ \ *) \)\(\[IndentingNewLine]\)\(Table[\((integrand[x, 
              0] + 4*integrand[x, 0.5] + integrand[x, 1])\)/6, \ {x, 0.1, 
        0.4, 0.1}]\)\)\)], "Input"],

Cell[BoxData[
    \({\(-0.09391764693248396`\), \(-0.13752165891286297`\), \
\(-0.1935656500259638`\), \(-0.2770196950438356`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[\((integrand[x, 0] + 4*integrand[x, 0.5] + integrand[x, 1])\)/
        6, \ {x, 0.6, 0.9, 0.1}]\)], "Input"],

Cell[BoxData[
    \({\(-0.34459721306186303`\), \(-0.3347819600904977`\), \
\(-0.3685707190995114`\), \(-0.4601217431551872`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\( (*\ 
      Now\ compute\ the\ integral\ by\ Simpson' 
        s\ rule\ *) \)\(\[IndentingNewLine]\)\( (*\(\(n = \(4\  : \ 
                result = \((\([7*f[s1] + 32*f[s2] + 12*f[s3] + 32*f[s4] + 
                    7*f[s5]\)\)\)\)\()\)\)/
        90, \ \[IndentingNewLine]where\ s1 = 0, \ s2 = 0.25, \ s3 = 0.5, \ 
      s4 = 0.75, \ s5 = 1, \ 
      and\ f = integrand; \[IndentingNewLine]compute\ for\ x =  .1\ to\  .4, \
\ and\  .6\ to\  .9\ \ *) \)\(\[IndentingNewLine]\)\(Table[\((7*
              integrand[x, 0] + 32*integrand[x, 0.25] + 
            12*integrand[x, 0.5] + 32*integrand[x, 0.75] + 
            7*integrand[x, 1])\)/90, \ {x, 0.1, 0.4, 0.1}]\)\)\)], "Input"],

Cell[BoxData[
    \({\(-0.09862321185674544`\), \(-0.14374033014073606`\), \
\(-0.1909844612437688`\), \(-0.2461201742114233`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[\((7*integrand[x, 0] + 32*integrand[x, 0.25] + 
            12*integrand[x, 0.5] + 32*integrand[x, 0.75] + 
            7*integrand[x, 1])\)/90, \ {x, 0.6, 0.9, 0.1}]\)], "Input"],

Cell[BoxData[
    \({\(-0.4000438180090988`\), \(-0.5742622893335606`\), \
\(-0.5979258754098253`\), \(-0.48132270003083527`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\( (*\ 
      Now\ compute\ the\ integral\ by\ Simpson' 
        s\ rule\ *) \)\(\[IndentingNewLine]\)\( (*n = \(8\  : \ result = \ 
          use\ rule\ Q4\), \ with\ s1 = 0, \ s2 = 1/8, \ s3 = 1/4, \ 
      s4 = 3/8, \ s5 = 1/2, \ s6 = 5/8, \ s7 = 3/4, \ s8 = 7/8, \ 
      s9 = \(1\ and\ f = 
          integrand\); \[IndentingNewLine]compute\ for\ x =  .1\ to\  .4, \ 
      and\  .6\ to\  .9\ \ *) \)\(\[IndentingNewLine]\)\(Table[\((integrand[
              x, 0] + 4*integrand[x, 1/8] + 2*integrand[x, 1/4] + 
            4*integrand[x, 3/8] + 2*integrand[x, 1/2] + 4*integrand[x, 5/8] + 
            2*integrand[x, 3/4] + 4*integrand[x, 7/8] + integrand[x, 1])\)/
        24, \ {x, 0.1, 0.4, 0.1}]\)\)\)], "Input"],

Cell[BoxData[
    \({\(-0.09877558767019097`\), \(-0.1416214646364944`\), \
\(-0.1944533684436237`\), \(-0.26130479952794744`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[\((integrand[x, 0] + 4*integrand[x, 1/8] + 2*integrand[x, 1/4] + 
            4*integrand[x, 3/8] + 2*integrand[x, 1/2] + 4*integrand[x, 5/8] + 
            2*integrand[x, 3/4] + 4*integrand[x, 7/8] + integrand[x, 1])\)/
        24, \ {x, 0.6, 0.9, 0.1}]\)], "Input"],

Cell[BoxData[
    \({\(-0.43782318086744726`\), \(-0.4833544966288896`\), \
\(-0.5534812644911337`\), \(-0.6428956681227064`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\( (*\ 
      Now\ compute\ the\ integral\ by\ Simpson' 
        s\ rule\ *) \)\(\[IndentingNewLine]\)\( (*n = \(16\  : \ result = \ 
          use\ rule\ Q4\), \ with\ s1 = 0, \ s2 = 1/16, \  ... , \ 
      s17 = \(1\ and\ f = 
          integrand\); \[IndentingNewLine]compute\ for\ x =  .1\ to\  .4, \ 
      and\  .6\ to\  .9\ \ *) \)\(\[IndentingNewLine]\)\(Table[\((integrand[
              x, 0] + 4*integrand[x, 1/16] + 2*integrand[x, 1/8] + 
            4*integrand[x, 3/16] + 2*integrand[x, 1/4] + 
            4*integrand[x, 5/16] + 2*integrand[x, 3/8] + 
            4*integrand[x, 7/16] + 2*integrand[x, 1/2] + 
            4*integrand[x, 9/16] + 2*integrand[x, 5/8] + 
            4*integrand[x, 11/16] + 2*integrand[x, 3/4] + 
            4*integrand[x, 13/16] + 2*integrand[x, 7/8] + 
            4*integrand[x, 15/16] + integrand[x, 1])\)/48, \ {x, 0.1, 0.4, 
        0.1}]\)\)\)], "Input"],

Cell[BoxData[
    \({\(-0.0986726909118044`\), \(-0.1424548654282425`\), \
\(-0.1970336384052438`\), \(-0.2593842119393386`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[\((integrand[x, 0] + 4*integrand[x, 1/16] + 2*integrand[x, 1/8] + 
            4*integrand[x, 3/16] + 2*integrand[x, 1/4] + 
            4*integrand[x, 5/16] + 2*integrand[x, 3/8] + 
            4*integrand[x, 7/16] + 2*integrand[x, 1/2] + 
            4*integrand[x, 9/16] + 2*integrand[x, 5/8] + 
            4*integrand[x, 11/16] + 2*integrand[x, 3/4] + 
            4*integrand[x, 13/16] + 2*integrand[x, 7/8] + 
            4*integrand[x, 15/16] + integrand[x, 1])\)/48, \ {x, 0.6, 0.9, 
        0.1}]\)], "Input"],

Cell[BoxData[
    \({\(-0.4168398691782726`\), \(-0.5207393323166589`\), \
\(-0.6065708393171786`\), \(-0.6032275007905096`\)}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(\( (*\ 
      Now\ compute\ the\ integral\ by\ Simpson' 
        s\ rule\ *) \)\(\[IndentingNewLine]\)\( (*n = \(32\  : \ result = \ 
          use\ rule\ Q4\), \ with\ s1 = 0, \ s2 = 1/16, \  ... , \ 
      s33 = \(1\ and\ f = 
          integrand\); \[IndentingNewLine]compute\ for\ x =  .1\ to\  .4, \ 
      and\  .6\ to\  .9\ \ *) \)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[\((integrand[x, 0] + 4*integrand[x, 1/32] + 
            2*integrand[x, 1/16] + 4*integrand[x, 3/32] + 
            2*integrand[x, 1/8] + 4*integrand[x, 5/32] + 
            2*integrand[x, 3/16] + 4*integrand[x, 7/32] + 
            2*integrand[x, 1/4] + 4*integrand[x, 9/32] + 
            2*integrand[x, 5/16] + 4*integrand[x, 11/32] + 
            2*integrand[x, 3/8] + 4*integrand[x, 13/132] + 
            2*integrand[x, 7/16] + 
            4*integrand[x, 15/32] + \[IndentingNewLine]2*integrand[x, 1/2] + 
            4*integrand[x, 17/32] + 2*integrand[x, 9/16] + 
            4*integrand[x, 19/32] + 2*integrand[x, 5/8] + 
            4*integrand[x, 21/32] + 2*integrand[x, 11/16] + 
            4*integrand[x, 23/32] + 2*integrand[x, 3/4] + 
            4*integrand[x, 25/32] + 2*integrand[x, 13/16] + 
            4*integrand[x, 27/32] + 2*integrand[x, 7/8] + 
            4*integrand[x, 29/32] + 2*integrand[x, 15/16] + 
            4*integrand[x, 31/32] + integrand[x, 1])\)/96, \ {x, 0.1, 0.4, 
        0.1}]\)], "Input"],

Cell[BoxData[
    \({\(-0.09567765553887049`\), \(-0.13801598265016635`\), \
\(-0.18952282505300375`\), \(-0.24856726948820737`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[\((integrand[x, 0] + 4*integrand[x, 1/32] + 
            2*integrand[x, 1/16] + 4*integrand[x, 3/32] + 
            2*integrand[x, 1/8] + 4*integrand[x, 5/32] + 
            2*integrand[x, 3/16] + 4*integrand[x, 7/32] + 
            2*integrand[x, 1/4] + 4*integrand[x, 9/32] + 
            2*integrand[x, 5/16] + 4*integrand[x, 11/32] + 
            2*integrand[x, 3/8] + 4*integrand[x, 13/132] + 
            2*integrand[x, 7/16] + 
            4*integrand[x, 15/32] + \[IndentingNewLine]2*integrand[x, 1/2] + 
            4*integrand[x, 17/32] + 2*integrand[x, 9/16] + 
            4*integrand[x, 19/32] + 2*integrand[x, 5/8] + 
            4*integrand[x, 21/32] + 2*integrand[x, 11/16] + 
            4*integrand[x, 23/32] + 2*integrand[x, 3/4] + 
            4*integrand[x, 25/32] + 2*integrand[x, 13/16] + 
            4*integrand[x, 27/32] + 2*integrand[x, 7/8] + 
            4*integrand[x, 29/32] + 2*integrand[x, 15/16] + 
            4*integrand[x, 31/32] + integrand[x, 1])\)/96, \ {x, 0.6, 0.9, 
        0.1}]\)], "Input"],

Cell[BoxData[
    \({\(-0.4239910320301139`\), \(-0.5067112939183841`\), \
\(-0.5827662367032577`\), \(-0.6398362453704579`\)}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 482},
WindowMargins->{{25, Automatic}, {32, Automatic}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 191, 3, 59, "Input"],

Cell[CellGroupData[{
Cell[1933, 56, 207, 3, 59, "Input"],
Cell[2143, 61, 59, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2239, 67, 73, 1, 27, "Input"],
Cell[2315, 70, 215, 4, 49, "Message"],
Cell[2533, 76, 59, 1, 26, "Output"]
}, Open  ]],
Cell[2607, 80, 73, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[2705, 85, 73, 1, 27, "Input"],
Cell[2781, 88, 215, 4, 49, "Message"],
Cell[2999, 94, 59, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3095, 100, 73, 1, 27, "Input"],
Cell[3171, 103, 354, 5, 91, "Message"],
Cell[3528, 110, 215, 4, 49, "Message"],
Cell[3746, 116, 58, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3841, 122, 73, 1, 27, "Input"],
Cell[3917, 125, 354, 5, 91, "Message"],
Cell[4274, 132, 215, 4, 49, "Message"],
Cell[4492, 138, 58, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4587, 144, 73, 1, 27, "Input"],
Cell[4663, 147, 156, 3, 51, "Message"],
Cell[4822, 152, 75, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4934, 158, 73, 1, 27, "Input"],
Cell[5010, 161, 354, 5, 91, "Message"],
Cell[5367, 168, 215, 4, 49, "Message"],
Cell[5585, 174, 58, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5680, 180, 73, 1, 27, "Input"],
Cell[5756, 183, 354, 5, 91, "Message"],
Cell[6113, 190, 215, 4, 49, "Message"],
Cell[6331, 196, 58, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6426, 202, 73, 1, 27, "Input"],
Cell[6502, 205, 354, 5, 91, "Message"],
Cell[6859, 212, 215, 4, 49, "Message"],
Cell[7077, 218, 58, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7172, 224, 73, 1, 27, "Input"],
Cell[7248, 227, 215, 4, 49, "Message"],
Cell[7466, 233, 58, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7561, 239, 71, 1, 27, "Input"],
Cell[7635, 242, 58, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7730, 248, 557, 9, 123, "Input"],
Cell[8290, 259, 142, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8469, 266, 134, 2, 59, "Input"],
Cell[8606, 270, 141, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8784, 277, 709, 12, 187, "Input"],
Cell[9496, 291, 142, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9675, 298, 205, 3, 75, "Input"],
Cell[9883, 303, 141, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10061, 310, 744, 12, 187, "Input"],
Cell[10808, 324, 142, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10987, 331, 293, 4, 107, "Input"],
Cell[11283, 337, 141, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11461, 344, 929, 16, 235, "Input"],
Cell[12393, 362, 140, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12570, 369, 545, 9, 171, "Input"],
Cell[13118, 380, 140, 2, 26, "Output"]
}, Open  ]],
Cell[13273, 385, 375, 7, 75, "Input"],

Cell[CellGroupData[{
Cell[13673, 396, 1061, 18, 299, "Input"],
Cell[14737, 416, 144, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14918, 423, 1061, 18, 299, "Input"],
Cell[15982, 443, 140, 2, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

